﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.ServiceModel.Channels;

namespace DictionaryExamples
{
    class Program
    {
        static void Main(string[] args)
        {
            // Listing 9-4. Lista inicjalizatora słownika.
            var myDictionary = new Dictionary<string, string>()
            {
                { "pies", "To nie kot." }, 
                { "morze", "Niebieskie falujące coś, w czym żyją syreny." }
            };

            // Listing 9-1. Odnajdywanie elementu w słowniku.
            string definition = myDictionary["morze"];
            Console.WriteLine("morze: " + definition);
        }

        static void InitWithNew()
        {
            // Listing 9-2. Słownik, którego klucze i wartości są łańcuchami znaków.
            Dictionary<string, string> myDictionary = new Dictionary<string, string>();
        }

        static void InitWithVar()
        {
            // Listing 9-3. Unikanie zespołu cieśni nadgarstka dzięki stosowaniu słowa kluczowego var.
            var myDictionary = new Dictionary<string, string>();
        }

        static void WcfDynamicProperties()
        {
            // Listing 9-6. Ustawianie dynamicznej właściwości w komunikacie WCF.
            Message wcfMessage = CreateMessageSomehow();
            HttpRequestMessageProperty reqProps = new HttpRequestMessageProperty();
            reqProps.Headers.Add(HttpRequestHeader.UserAgent, "Moja wartość User-Agent");
            wcfMessage.Properties[HttpRequestMessageProperty.Name] = reqProps;
        }

        private static Message CreateMessageSomehow()
        {
            return null;
        }


        class BuildingInfo { public int ID { get; set; } public string Name { get; set; } }
        class DS { public List<BuildingInfo> Buildings { get; set; } }

        static void LinqToDictionary()
        {
            DS MyDataSource = new DS
            {
                Buildings = 
                {
                    new BuildingInfo { ID = 1, Name = "Pałac Kultury i Nauki" },
                    new BuildingInfo { ID = 2, Name = "Zamek Królewski w Warszawie" },
                    new BuildingInfo { ID = 2, Name = "Wawel" }
                }
            };

            // Listing 9-11. Operator ToDictionary LINQ
            IDictionary<int, string> buildingIdToNameMap =
            MyDataSource.Buildings.ToDictionary(
            building => building.ID,
            building => building.Name);

        }
    }
}
